<?php
/* --------------------------------------------------------------
   ImageConfiguration.php 2022-12-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\ImageProcessing\Model\Configuration;

/**
 * Interface ImageConfiguration
 *
 * @package Gambio\Admin\Modules\ImageProcessing\Model\Configuration
 */
interface ImageConfiguration
{
    /**
     * Resulting height of processed image.
     *
     * @return int
     */
    public function height(): int;
    
    
    /**
     * Resulting width of processed image.
     *
     * @return int
     */
    public function width(): int;
    
    
    /**
     * Absolute path to image directory.
     *
     * @return string
     */
    public function path(): string;
}